package pogamutjavabot080430;

import cz.cuni.pogamut.Client.AgentBody;
import cz.cuni.pogamut.Client.AgentMemory;
import cz.cuni.pogamut.Client.GameMap;
import cz.cuni.pogamut.MessageObjects.Triple;

public class MyPathMaker extends Object
{
    private static final int OnSamePlace = 380;
    private static final int maxTimeIterRun = 11;
    private Triple lastLocation = null;
            
    private int iterace = 0;
    private Triple targetLocation = null;
    
    private GameMap gameMap;
    private AgentMemory memory;
    private AgentBody body;
    
    MyPathMaker(GameMap gameMap, AgentMemory memory, AgentBody body)
    {
        this.gameMap = gameMap;
        this.memory = memory;
        this.body = body;
    }
    
    void reset()
    {
        targetLocation = null;
        iterace = 0;
        lastLocation = memory.getAgentLocation();
    }
    
    boolean runToTarget(Triple target)
    {
        if (target != targetLocation)
        {
            reset();
            targetLocation = target;
        }
        
        // Aby necekal nez najde cestu
        /*if (!memory.isMoving())
            body.runToLocation(targetLocation);*/
                
        // Pokud o neco zavadim tak vyzkocim 
        if (memory.isColliding())
        {
            /*if (memory.isFalling())
                return false;*/
            body.jump();
        }

        // Pokud bezim a dlouho se o moc nepohnu
        if (++iterace >= maxTimeIterRun)
            if (Triple.distanceInSpace(memory.getAgentLocation(), lastLocation) < OnSamePlace)
                return false;
            else
            {
                lastLocation = memory.getAgentLocation();
                iterace = 0;
            }
        
        gameMap.safeRunToLocation(targetLocation);
        return true;
    }
}